// Copyright 2012, Effective Objects
//
// ProLat for .Net example using C++/CLI
//

#pragma once

namespace ExSimple {

	using namespace System;
	using namespace System::ComponentModel;
	using namespace System::Collections;
	using namespace System::Windows::Forms;
	using namespace System::Data;
	using namespace System::Drawing;
    using namespace ProLatNet;      // ProLat for .Net namespace

	/// <summary>
	/// Summary for Form1
	/// </summary>
	public ref class Form1 : public System::Windows::Forms::Form
	{
	public:
		Form1(void)
		{
			InitializeComponent();
		}

	protected:
		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		~Form1()
		{
			if (components)
			{
				delete components;
			}
		}
    private: System::Windows::Forms::Button^  buttonTransform;
    protected: 
    internal: System::Windows::Forms::Label^  Label7;
    private: 
    internal: System::Windows::Forms::Label^  Label6;
    internal: System::Windows::Forms::Label^  Label5;
    internal: System::Windows::Forms::TextBox^  TextAz;
    internal: System::Windows::Forms::TextBox^  TextALaty;
    internal: System::Windows::Forms::TextBox^  TextALonx;

    internal: System::Windows::Forms::Label^  Label8;
    internal: System::Windows::Forms::Label^  Label9;
    internal: System::Windows::Forms::Label^  Label10;
    internal: System::Windows::Forms::TextBox^  TextBz;
    internal: System::Windows::Forms::TextBox^  TextBLaty;
    internal: System::Windows::Forms::TextBox^  TextBLonx;

	private:
		/// <summary>
		/// Required designer variable.
		/// </summary>
		System::ComponentModel::Container ^components;

#pragma region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		void InitializeComponent(void)
		{
            this->buttonTransform = (gcnew System::Windows::Forms::Button());
            this->Label7 = (gcnew System::Windows::Forms::Label());
            this->Label6 = (gcnew System::Windows::Forms::Label());
            this->Label5 = (gcnew System::Windows::Forms::Label());
            this->TextAz = (gcnew System::Windows::Forms::TextBox());
            this->TextALaty = (gcnew System::Windows::Forms::TextBox());
            this->TextALonx = (gcnew System::Windows::Forms::TextBox());
            this->Label8 = (gcnew System::Windows::Forms::Label());
            this->Label9 = (gcnew System::Windows::Forms::Label());
            this->Label10 = (gcnew System::Windows::Forms::Label());
            this->TextBz = (gcnew System::Windows::Forms::TextBox());
            this->TextBLaty = (gcnew System::Windows::Forms::TextBox());
            this->TextBLonx = (gcnew System::Windows::Forms::TextBox());
            this->SuspendLayout();
            // 
            // buttonTransform
            // 
            this->buttonTransform->Location = System::Drawing::Point(95, 106);
            this->buttonTransform->Name = L"buttonTransform";
            this->buttonTransform->Size = System::Drawing::Size(91, 35);
            this->buttonTransform->TabIndex = 0;
            this->buttonTransform->Text = L"Transform";
            this->buttonTransform->UseVisualStyleBackColor = true;
            this->buttonTransform->Click += gcnew System::EventHandler(this, &Form1::buttonTransform_Click);
            // 
            // Label7
            // 
            this->Label7->AutoSize = true;
            this->Label7->Location = System::Drawing::Point(12, 69);
            this->Label7->Name = L"Label7";
            this->Label7->Size = System::Drawing::Size(61, 13);
            this->Label7->TabIndex = 20;
            this->Label7->Text = L"Height or z:";
            // 
            // Label6
            // 
            this->Label6->AutoSize = true;
            this->Label6->Location = System::Drawing::Point(12, 43);
            this->Label6->Name = L"Label6";
            this->Label6->Size = System::Drawing::Size(68, 13);
            this->Label6->TabIndex = 19;
            this->Label6->Text = L"Latitude or y:";
            // 
            // Label5
            // 
            this->Label5->AutoSize = true;
            this->Label5->Location = System::Drawing::Point(12, 17);
            this->Label5->Name = L"Label5";
            this->Label5->Size = System::Drawing::Size(77, 13);
            this->Label5->TabIndex = 18;
            this->Label5->Text = L"Longitude or x:";
            // 
            // TextAz
            // 
            this->TextAz->Font = (gcnew System::Drawing::Font(L"Microsoft Sans Serif", 9.75F, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, 
                static_cast<System::Byte>(0)));
            this->TextAz->Location = System::Drawing::Point(95, 64);
            this->TextAz->Name = L"TextAz";
            this->TextAz->Size = System::Drawing::Size(158, 22);
            this->TextAz->TabIndex = 23;
            // 
            // TextALaty
            // 
            this->TextALaty->Font = (gcnew System::Drawing::Font(L"Microsoft Sans Serif", 9.75F, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, 
                static_cast<System::Byte>(0)));
            this->TextALaty->Location = System::Drawing::Point(95, 38);
            this->TextALaty->Name = L"TextALaty";
            this->TextALaty->Size = System::Drawing::Size(158, 22);
            this->TextALaty->TabIndex = 22;
            this->TextALaty->Text = L"43 N";
            // 
            // TextALonx
            // 
            this->TextALonx->Font = (gcnew System::Drawing::Font(L"Microsoft Sans Serif", 9.75F, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, 
                static_cast<System::Byte>(0)));
            this->TextALonx->Location = System::Drawing::Point(95, 12);
            this->TextALonx->Name = L"TextALonx";
            this->TextALonx->Size = System::Drawing::Size(158, 22);
            this->TextALonx->TabIndex = 21;
            this->TextALonx->Text = L"83 W";
            // 
            // Label8
            // 
            this->Label8->AutoSize = true;
            this->Label8->Location = System::Drawing::Point(13, 213);
            this->Label8->Name = L"Label8";
            this->Label8->Size = System::Drawing::Size(61, 13);
            this->Label8->TabIndex = 29;
            this->Label8->Text = L"Height or z:";
            // 
            // Label9
            // 
            this->Label9->AutoSize = true;
            this->Label9->Location = System::Drawing::Point(13, 187);
            this->Label9->Name = L"Label9";
            this->Label9->Size = System::Drawing::Size(68, 13);
            this->Label9->TabIndex = 28;
            this->Label9->Text = L"Latitude or y:";
            // 
            // Label10
            // 
            this->Label10->AutoSize = true;
            this->Label10->Location = System::Drawing::Point(13, 161);
            this->Label10->Name = L"Label10";
            this->Label10->Size = System::Drawing::Size(77, 13);
            this->Label10->TabIndex = 27;
            this->Label10->Text = L"Longitude or x:";
            // 
            // TextBz
            // 
            this->TextBz->Font = (gcnew System::Drawing::Font(L"Microsoft Sans Serif", 9.75F, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, 
                static_cast<System::Byte>(0)));
            this->TextBz->Location = System::Drawing::Point(95, 213);
            this->TextBz->Name = L"TextBz";
            this->TextBz->Size = System::Drawing::Size(158, 22);
            this->TextBz->TabIndex = 26;
            // 
            // TextBLaty
            // 
            this->TextBLaty->Font = (gcnew System::Drawing::Font(L"Microsoft Sans Serif", 9.75F, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, 
                static_cast<System::Byte>(0)));
            this->TextBLaty->Location = System::Drawing::Point(95, 187);
            this->TextBLaty->Name = L"TextBLaty";
            this->TextBLaty->Size = System::Drawing::Size(158, 22);
            this->TextBLaty->TabIndex = 25;
            // 
            // TextBLonx
            // 
            this->TextBLonx->Font = (gcnew System::Drawing::Font(L"Microsoft Sans Serif", 9.75F, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, 
                static_cast<System::Byte>(0)));
            this->TextBLonx->Location = System::Drawing::Point(95, 161);
            this->TextBLonx->Name = L"TextBLonx";
            this->TextBLonx->Size = System::Drawing::Size(158, 22);
            this->TextBLonx->TabIndex = 24;
            // 
            // Form1
            // 
            this->AutoScaleDimensions = System::Drawing::SizeF(6, 13);
            this->AutoScaleMode = System::Windows::Forms::AutoScaleMode::Font;
            this->ClientSize = System::Drawing::Size(482, 262);
            this->Controls->Add(this->Label8);
            this->Controls->Add(this->Label9);
            this->Controls->Add(this->Label10);
            this->Controls->Add(this->TextBz);
            this->Controls->Add(this->TextBLaty);
            this->Controls->Add(this->TextBLonx);
            this->Controls->Add(this->TextAz);
            this->Controls->Add(this->TextALaty);
            this->Controls->Add(this->TextALonx);
            this->Controls->Add(this->Label7);
            this->Controls->Add(this->Label6);
            this->Controls->Add(this->Label5);
            this->Controls->Add(this->buttonTransform);
            this->Name = L"Form1";
            this->Text = L"ExSimple";
            this->ResumeLayout(false);
            this->PerformLayout();

        }
#pragma endregion
    private: System::Void buttonTransform_Click(System::Object^  sender, System::EventArgs^  e) {
        try 
        {
            // Get ProLat CoordSys objects for each coordinate system
            CoordSys^ A = CoordSys::GetCS("LAT_LONG", "LAT-LONG", "WGS84", "METERS");
            CoordSys^ B = CoordSys::GetCS("UTM", "UTM-17N", "WGS84", "METERS");

            // Create managed arrays to hold the coordinates
            array<double>^ lon_x = gcnew array<double>(1);
            array<double>^ lat_y = gcnew array<double>(1);
            array<double>^ z = gcnew array<double>(1);

            // Use the ProLat DMS class to read coordinates into the arrays
            lon_x[0] = DMS::GetLon(TextALonx->Text);
            lat_y[0] = DMS::GetLat(TextALaty->Text);
            if (TextAz->Text->Length > 0)
                z[0] = double::Parse(TextAz->Text);
            else
                z[0] = 0;

            // Perform the coordinate conversion
            CoordSys::Transform(A, B, lon_x, lat_y, z, 1);

            // Display the results
            TextBLonx->Text = Math::Round(lon_x[0], 9).ToString();
            TextBLaty->Text = Math::Round(lat_y[0], 9).ToString();
            TextBz->Text = Math::Round(z[0], 9).ToString();
        }
        catch(CSConfigException^ e)
        {
            // Display ProLat messages here
            MessageBox::Show(e->Message, "ProLat message");
        }
        catch(Exception^ e)
        {
            MessageBox::Show(e->Message, "Exception detected");
        }

    }
};
}

