﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Phone.Controls;
using ProLatNet;

namespace ProLatWPA
{
    public partial class Page1 : PhoneApplicationPage
    {
        public Page1()
        {
            InitializeComponent();

            // Do the one time initialization here
            List<string> groups = CoordSys.GetGroups();
            listBoxGroup.ItemsSource = groups;
        }

        protected override void OnNavigatedTo(System.Windows.Navigation.NavigationEventArgs e)
        {
            base.OnNavigatedTo(e);

            // Prepare the list boxes

            // Select the group
            List<string> groups = CoordSys.GetGroups();
            int iDef = App.csDefToChange;
            int i;
            for (i=0; i<groups.Count; i++)
            {
                if (groups[i].Equals(App.csDefs[iDef].Group))
                    break;
            }
            listBoxGroup.SelectedIndex = i;
            listBoxGroup.UpdateLayout();
            listBoxGroup.ScrollIntoView(listBoxGroup.Items[listBoxGroup.SelectedIndex]);

            List<string> systems = CoordSys.GetSystems(groups[i]);
            for (i = 0; i < systems.Count; i++)
            {
                if (systems[i].Equals(App.csDefs[iDef].System))
                    break;
            }
            listBoxSystem.ItemsSource = systems;
            listBoxSystem.SelectedIndex = i;
            listBoxSystem.UpdateLayout();
            listBoxSystem.ScrollIntoView(listBoxSystem.Items[listBoxSystem.SelectedIndex]);

            List<string> datums = CoordSys.GetDatums();
            for (i = 0; i < datums.Count; i++)
            {
                if (datums[i].Equals(App.csDefs[iDef].Datum))
                    break;
            }
            listBoxDatum.ItemsSource = datums;
            listBoxDatum.SelectedIndex = i;
            listBoxDatum.UpdateLayout();
            listBoxDatum.ScrollIntoView(listBoxDatum.Items[listBoxDatum.SelectedIndex]);

            List<string> units = CoordSys.GetUnits();
            for (i = 0; i < units.Count; i++)
            {
                if (units[i].Equals(App.csDefs[iDef].Units))
                    break;
            }
            listBoxUnits.ItemsSource = units;
            listBoxUnits.SelectedIndex = i;
            listBoxDatum.UpdateLayout();
            listBoxUnits.ScrollIntoView(listBoxUnits.Items[listBoxUnits.SelectedIndex]);

            checkProj4.IsChecked = App.csDefs[iDef].UseProj4;
            editProj4.Text = App.csDefs[iDef].Proj4;
        }
        
        private void buttonDone_Click(object sender, RoutedEventArgs e)
        {
            // Copy the current definition to the global location
            App.csDefs[App.csDefToChange].Group = (string) listBoxGroup.SelectedValue;
            App.csDefs[App.csDefToChange].System = (string)listBoxSystem.SelectedValue;
            App.csDefs[App.csDefToChange].Datum = (string)listBoxDatum.SelectedValue;
            App.csDefs[App.csDefToChange].Units = (string)listBoxUnits.SelectedValue;
            App.csDefs[App.csDefToChange].UseProj4 = (bool) checkProj4.IsChecked;
            App.csDefs[App.csDefToChange].Proj4 = editProj4.Text;

            NavigationService.GoBack();
        }

        private void listBoxGroup_SelectionChanged(object sender, SelectionChangedEventArgs e)
        {
            string group = (string) listBoxGroup.SelectedValue;
            List<string> systems = CoordSys.GetSystems(group);
            listBoxSystem.ItemsSource = systems;
            listBoxSystem.SelectedIndex = 0;
            listBoxSystem.UpdateLayout();
            listBoxSystem.ScrollIntoView(listBoxSystem.Items[listBoxSystem.SelectedIndex]);
        }
    }
}