﻿' Copyright 2012, Effective Objects
'
' This example illustrates using ProLat for .Net

Imports ProLatNet

Public Class Main
    Dim GroupsA, GroupsB, GroupDesc, GroupDefDatum As List(Of String)
    Dim SystemsA, SystemDescA As List(Of String)
    Dim SystemsB, SystemDescB As List(Of String)
    Dim DatumsA, DatumsB, DatumDesc, UnitsA, UnitsB, UnitDesc As List(Of String)

    Private Sub Main_Load(sender As System.Object, e As System.EventArgs) Handles MyBase.Load
        ' Fill the combo boxes with defaults
        Try
            ' Get the geodesy lists of groups, datums, and units
            GroupsA = CoordSys.GetGroups(GroupDesc, GroupDefDatum)
            DatumsA = CoordSys.GetDatums(DatumDesc)
            UnitsA = CoordSys.GetUnits(UnitDesc)
            ' Set combo box data sources first before setting any indexes (except system boxes which get filled when group is selected).
            ComboAGroup.DataSource = GroupsA
            ComboADatum.DataSource = DatumsA
            ComboAUnits.DataSource = UnitsA
            ' Set the default A coordinate system
            ComboAGroup.SelectedItem = "LAT_LONG"  ' This causes the system combo box to be filled
            ComboASystem.SelectedItem = "LAT-LONG"
            ComboADatum.SelectedItem = "WGS84"
            ComboAUnits.SelectedItem = "METERS"    ' Even though it is actually lat/lon

            GroupsB = New List(Of String)(GroupsA) ' Get copies
            DatumsB = New List(Of String)(DatumsA)
            UnitsB = New List(Of String)(UnitsA)
            ComboBGroup.DataSource = GroupsB       ' Set data sources
            ComboBDatum.DataSource = DatumsB
            ComboBUnits.DataSource = UnitsB
            ComboBGroup.SelectedItem = "UTM"       ' Causes system combo box to be filled
            ComboBSystem.SelectedItem = "UTM-17N"
            ComboBDatum.SelectedItem = "WGS84"
            ComboBUnits.SelectedItem = "METERS"

            ' Change this to your local installation path
            ' CoordSys.AddFileLocationFolder("c:\\prolatnet\\geodesy")

        Catch ex As CSConfigException
            MsgBox(ex.Message)
        Catch ex As Exception
            MsgBox(ex.Message)
        End Try

    End Sub

    ' Two function to enable and disable coordinate system controls depending on the radio buttons
    Private Sub UpdateCoordinateSystemControlsA()
        If RadioAGeodesy.Checked Then
            ComboAGroup.Enabled = True
            ComboASystem.Enabled = True
            ComboADatum.Enabled = True
            ComboAUnits.Enabled = True

            TextAProj.Enabled = False
        Else
            ComboAGroup.Enabled = False
            ComboASystem.Enabled = False
            ComboADatum.Enabled = False
            ComboAUnits.Enabled = False

            TextAProj.Enabled = True
        End If
    End Sub

    Private Sub UpdateCoordinateSystemControlsB()
        If RadioBGeodesy.Checked Then
            ComboBGroup.Enabled = True
            ComboBSystem.Enabled = True
            ComboBDatum.Enabled = True
            ComboBUnits.Enabled = True

            TextBProj.Enabled = False
        Else
            ComboBGroup.Enabled = False
            ComboBSystem.Enabled = False
            ComboBDatum.Enabled = False
            ComboBUnits.Enabled = False

            TextBProj.Enabled = True
        End If
    End Sub

    Private Sub RadioAGeodesy_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles RadioAGeodesy.CheckedChanged
        UpdateCoordinateSystemControlsA()
    End Sub

    Private Sub RadioAProj_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles RadioAProj.CheckedChanged
        UpdateCoordinateSystemControlsA()
    End Sub

    Private Sub RadioBGeodesy_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles RadioBGeodesy.CheckedChanged
        UpdateCoordinateSystemControlsB()
    End Sub

    Private Sub RadioBProj_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles RadioBProj.CheckedChanged
        UpdateCoordinateSystemControlsB()
    End Sub

    Private Sub ComboAGroup_SelectedIndexChanged(sender As System.Object, e As System.EventArgs) Handles ComboAGroup.SelectedIndexChanged
        LblAGroupDesc.Text = GroupDesc(ComboAGroup.SelectedIndex)
        SystemsA = CoordSys.GetSystems(ComboAGroup.Text, SystemDescA)       ' Get the systems for the new group
        ComboASystem.DataSource = SystemsA                                  ' Set the systems combo box
        ComboASystem.SelectedIndex = 0                                      ' Select the first system

        If GroupDefDatum(ComboAGroup.SelectedIndex) <> "Any" Then
            ComboADatum.SelectedItem = GroupDefDatum(ComboAGroup.SelectedIndex) ' Set the datum to the group's default datum
        Else
            ComboADatum.SelectedItem = "WGS84"
        End If
        FillProjA()
    End Sub

    Private Sub FillProjA()
        Try
            Dim A As CoordSys = CoordSys.GetCS(ComboAGroup.Text, ComboASystem.Text, ComboADatum.Text, ComboAUnits.Text)
            Dim def As String = A.getDef()
            TextAProj.Text = def
        Catch e As Exception
            ' Do nothing
        End Try
    End Sub

    Private Sub FillProjB()
        Try
            Dim B As CoordSys = CoordSys.GetCS(ComboBGroup.Text, ComboBSystem.Text, ComboBDatum.Text, ComboBUnits.Text)
            Dim def As String = B.getDef()
            TextBProj.Text = def
        Catch e As Exception
            ' Do nothing
        End Try
    End Sub


    Private Sub ComboASystem_SelectedIndexChanged(sender As System.Object, e As System.EventArgs) Handles ComboASystem.SelectedIndexChanged
        LblASystemDesc.Text = SystemDescA(ComboASystem.SelectedIndex)        ' Set the description of the system
        FillProjA()
    End Sub

    Private Sub ComboADatum_SelectedIndexChanged(sender As System.Object, e As System.EventArgs) Handles ComboADatum.SelectedIndexChanged
        LblADatumDesc.Text = DatumDesc(ComboADatum.SelectedIndex)           ' Set the description of the datum
        FillProjA()
    End Sub

    Private Sub ComboAUnits_SelectedIndexChanged(sender As System.Object, e As System.EventArgs) Handles ComboAUnits.SelectedIndexChanged
        LblAUnitDesc.Text = UnitDesc(ComboAUnits.SelectedIndex)             ' Set the description of the unit
        FillProjA()
    End Sub

    Private Sub ComboBGroup_SelectedIndexChanged(sender As System.Object, e As System.EventArgs) Handles ComboBGroup.SelectedIndexChanged
        LblBGroupDesc.Text = GroupDesc(ComboBGroup.SelectedIndex)
        SystemsB = CoordSys.GetSystems(ComboBGroup.Text, SystemDescB)       ' Get the systems for the new group
        ComboBSystem.DataSource = SystemsB                                  ' Set the systems combo box
        ComboBSystem.SelectedIndex = 0                                      ' Select the first system

        If GroupDefDatum(ComboBGroup.SelectedIndex) <> "Any" Then
            ComboBDatum.SelectedItem = GroupDefDatum(ComboBGroup.SelectedIndex) ' Set the datum to the group's default datum
        Else
            ComboBDatum.SelectedItem = "WGS84"
        End If
        FillProjB()
    End Sub

    Private Sub ComboBSystem_SelectedIndexChanged(sender As System.Object, e As System.EventArgs) Handles ComboBSystem.SelectedIndexChanged
        LblBSystemDesc.Text = SystemDescB(ComboBSystem.SelectedIndex)        ' Set the description of the system
        FillProjB()
    End Sub

    Private Sub ComboBDatum_SelectedIndexChanged(sender As System.Object, e As System.EventArgs) Handles ComboBDatum.SelectedIndexChanged
        LblBDatumDesc.Text = DatumDesc(ComboBDatum.SelectedIndex)           ' Set the description of the datum
        FillProjB()
    End Sub

    Private Sub ComboBUnits_SelectedIndexChanged(sender As System.Object, e As System.EventArgs) Handles ComboBUnits.SelectedIndexChanged
        LblBUnitDesc.Text = UnitDesc(ComboBUnits.SelectedIndex)             ' Set the description of the unit
        FillProjB()
    End Sub

    Private Sub ButtonConvertAB_Click(sender As System.Object, e As System.EventArgs) Handles ButtonConvertAB.Click
        If TextALonx.Text.Length = 0 Or TextALaty.Text.Length = 0 Then
            MsgBox("Please enter input values in section A", MsgBoxStyle.OkOnly)
            Exit Sub
        End If

        Try
            Dim A, B As CoordSys
            If RadioAGeodesy.Checked = True Then
                A = CoordSys.GetCS(ComboAGroup.Text, ComboASystem.Text, ComboADatum.Text, ComboAUnits.Text)
            Else
                A = CoordSys.GetCS(TextAProj.Text)
            End If

            If RadioBGeodesy.Checked = True Then
                B = CoordSys.GetCS(ComboBGroup.Text, ComboBSystem.Text, ComboBDatum.Text, ComboBUnits.Text)
            Else
                B = CoordSys.GetCS(TextBProj.Text)
            End If

            Dim LonX(1), LatY(1), Z(1) As Double

            LonX(0) = DMS.GetLon(TextALonx.Text)
            LatY(0) = DMS.GetLat(TextALaty.Text)

            Dim valZ As Double = 0
            If TextAz.Text.Length > 0 Then
                valZ = Double.Parse(TextAz.Text)
            End If
            Z(0) = valZ

            CoordSys.Transform(A, B, LonX, LatY, Z, 1)

            TextBLonx.Text = Math.Round(LonX(0), 9).ToString
            TextBLaty.Text = Math.Round(LatY(0), 9).ToString
            TextBz.Text = Math.Round(Z(0), 9).ToString
        Catch ex As CSConfigException
            MessageBox.Show(ex.Message, "ProLat message", MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
        End Try
    End Sub

    Private Sub ButtonConvertBA_Click(sender As System.Object, e As System.EventArgs) Handles ButtonConvertBA.Click
        If TextBLonx.Text.Length = 0 Or TextBLaty.Text.Length = 0 Then
            MsgBox("Please enter input values in section B", MsgBoxStyle.OkOnly)
            Exit Sub
        End If

        Try
            Dim A, B As CoordSys
            If RadioAGeodesy.Checked = True Then
                A = CoordSys.GetCS(ComboAGroup.Text, ComboASystem.Text, ComboADatum.Text, ComboAUnits.Text)
            Else
                A = CoordSys.GetCS(TextAProj.Text)
            End If

            If RadioBGeodesy.Checked = True Then
                B = CoordSys.GetCS(ComboBGroup.Text, ComboBSystem.Text, ComboBDatum.Text, ComboBUnits.Text)
            Else
                B = CoordSys.GetCS(TextBProj.Text)
            End If

            Dim LonX(1), LatY(1), Z(1) As Double

            LonX(0) = DMS.GetLon(TextBLonx.Text)
            LatY(0) = DMS.GetLat(TextBLaty.Text)

            Dim valZ As Double = 0
            If TextBz.Text.Length > 0 Then
                valZ = Double.Parse(TextBz.Text)
            End If
            Z(0) = valZ

            CoordSys.Transform(B, A, LonX, LatY, Z, 1)

            TextALonx.Text = Math.Round(LonX(0), 9).ToString
            TextALaty.Text = Math.Round(LatY(0), 9).ToString
            TextAz.Text = Math.Round(Z(0), 9).ToString
        Catch ex As CSConfigException
            MessageBox.Show(ex.Message, "ProLat message", MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
        End Try
    End Sub

    Private Sub ButtonDMS_Click(sender As System.Object, e As System.EventArgs) Handles ButtonDMS.Click
        Dim Lon() As Double = Nothing
        Dim Lat() As Double = Nothing
        Dim Z() As Double = Nothing
        Dim sData As String = "80 25 49.12 W  35 41 29 N" & vbCr & vbLf & _
                              "12 25 49.12 E  15 41 29 S  225.4"

        Dim msg As String = Nothing
        Dim ErrorCount As Integer = DMS.GetDMS(sData, 1, Lon, Lat, Z, msg)

        Dim Output As String = "GetDMS returned:" & vbCr & vbLf
        If (ErrorCount > 0) Then
            Output = Output & "Errors detected: " & ErrorCount.ToString() & vbCr & vbLf
        End If

        If (msg.Length > 0) Then
            Output = Output & "Return message: " & msg & vbCr & vbLf
        End If

        For i = 0 To 1
            Output = Output & Lon(i).ToString() & " " & Lat(i).ToString() & vbCr & vbLf
        Next

        MsgBox(Output)
    End Sub

    Private Sub ButtonMGRS_Click(sender As System.Object, e As System.EventArgs) Handles ButtonMGRS.Click
        Try
            Dim Mgrs1 As MGRS = New MGRS()  ' Uses default WGS84 ellipsoid.  
            ' For NAD27 ellipsoid use: New MGRS("datum=NAD27")

            Dim Lon As Double = 5
            Dim Lat As Double = 57
            Dim OutMGRS As String = Mgrs1.ConvertFromGeodetic(Lon, Lat)
            MessageBox.Show("MGRS example:  lon/lat: " & _
                    Lon.ToString() & " " & Lat.ToString() & vbCrLf & _
                    "MGRS: " + OutMGRS)
        Catch ex As CSConfigException
            MessageBox.Show(ex.Message)
        End Try
    End Sub
End Class
